package ru.yandex.partner.jsonapi.crnk.exceptions;

import java.util.List;

import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.TranslatableError;

public class CrnkResponseStatusException extends RuntimeException {
    private final HttpErrorStatusEnum httpErrorStatusEnum;

    private final List<TranslatableError> apiErrors;

    public CrnkResponseStatusException(HttpErrorStatusEnum httpErrorStatusEnum) {
        this(httpErrorStatusEnum, null, null, null);
    }

    public CrnkResponseStatusException(HttpErrorStatusEnum httpErrorStatusEnum, GettextMsg externalMessage) {
        this(httpErrorStatusEnum, externalMessage, null, null);
    }

    public CrnkResponseStatusException(HttpErrorStatusEnum httpErrorStatusEnum, GettextMsg externalMessage,
                                       Throwable cause) {
        this(httpErrorStatusEnum, externalMessage, null, cause);
    }

    public CrnkResponseStatusException(HttpErrorStatusEnum httpErrorStatusEnum, GettextMsg externalMessage,
                                       String internalMessage) {
        this(httpErrorStatusEnum, externalMessage, internalMessage, null);
    }

    public CrnkResponseStatusException(HttpErrorStatusEnum httpErrorStatusEnum, GettextMsg externalMessage,
                                       String internalMessage,
                                       Throwable cause) {
        super(internalMessage, cause);

        this.httpErrorStatusEnum = httpErrorStatusEnum;

        this.apiErrors = List.of(new TranslatableError(null, externalMessage));
    }

    public CrnkResponseStatusException(HttpErrorStatusEnum httpErrorStatusEnum, List<TranslatableError> apiErrors) {
        this.httpErrorStatusEnum = httpErrorStatusEnum;

        this.apiErrors = apiErrors;
    }

    public HttpErrorStatusEnum getHttpErrorStatusEnum() {
        return httpErrorStatusEnum;
    }

    public List<TranslatableError> getApiErrors() {
        return apiErrors;
    }
}
