package ru.yandex.partner.jsonapi.crnk.exceptions;

import java.util.List;

import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.TranslatableError;

public class ValidationException extends CrnkResponseStatusException {
    public ValidationException() {
        super(HttpErrorStatusEnum.ERROR__VALIDATION);
    }

    public ValidationException(GettextMsg externalMessage) {
        super(HttpErrorStatusEnum.ERROR__VALIDATION, externalMessage);
    }

    public ValidationException(GettextMsg externalMessage, Throwable cause) {
        super(HttpErrorStatusEnum.ERROR__VALIDATION, externalMessage, cause);
    }

    public ValidationException(GettextMsg externalMessage, String internalMessage) {
        super(HttpErrorStatusEnum.ERROR__VALIDATION, externalMessage, internalMessage);
    }

    public ValidationException(GettextMsg externalMessage, String internalMessage,
                               Throwable cause) {
        super(HttpErrorStatusEnum.ERROR__VALIDATION, externalMessage, internalMessage, cause);
    }

    public ValidationException(List<TranslatableError> apiErrors) {
        super(HttpErrorStatusEnum.ERROR__VALIDATION, apiErrors);
    }
}
