package ru.yandex.partner.jsonapi.crnk.exceptions.mapper;

import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.jsonapi.response.PartnerErrorResponseBuilder;

@Component
public class CrnkResponseStatusExceptionMapper implements ExceptionMapper<CrnkResponseStatusException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkResponseStatusExceptionMapper.class);
    private final PartnerErrorResponseBuilder partnerErrorResponseBuilder;

    @Autowired
    public CrnkResponseStatusExceptionMapper(PartnerErrorResponseBuilder partnerErrorResponseBuilder) {
        this.partnerErrorResponseBuilder = partnerErrorResponseBuilder;
    }

    @Override
    public ErrorResponse toErrorResponse(CrnkResponseStatusException exception) {
        ErrorResponse errorResponse = partnerErrorResponseBuilder.buildErrorResponse(exception);

        if (errorResponse.getHttpStatus() > 499) {
            LOGGER.error(exception.getMessage(), exception);
        }

        return errorResponse;
    }

    @Override
    public CrnkResponseStatusException fromErrorResponse(ErrorResponse errorResponse) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean accepts(ErrorResponse errorResponse) {
        return false;
    }
}
