package ru.yandex.partner.jsonapi.crnk.exceptions.mapper;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile("!prod")
@Component
public class ErrorDataNotForProd implements ErrorDataWithProfile {

    @Override
    public ErrorData getErrorData(Exception exception, String errorId, String code, String title) {
        return new ErrorDataBuilder()
                .setId(errorId)
                .setCode(code)
                .setTitle(title)
                .setDetail(exception.getMessage())
                .build();

    }
}
