package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

public interface ApiFieldsAccessRulesService<T> {
    Set<String> calculate(UserAuthentication userAuthentication, T entity);

    Set<String> calculate(UserAuthentication userAuthentication, T entity, IncomingApiFields updatedFields);

    List<ModelProperty<? extends Model, ?>> getRequiredModelProperties();

    Set<ModelProperty<? extends Model, ?>> getRequiredModelPropertiesByJsonName(String jsonName);

    Set<String> getNever();
}
