package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.List;
import java.util.Objects;

class CheckInnerField {
    private final String rootFieldName;
    private final List<String> jsonPath;
    private final String rightName;

    CheckInnerField(String rootFieldName, List<String> jsonPath, String rightName) {
        this.rootFieldName = Objects.requireNonNull(rootFieldName);
        this.jsonPath = Objects.requireNonNull(jsonPath);
        this.rightName = Objects.requireNonNull(rightName);
    }

    String getRootFieldName() {
        return rootFieldName;
    }

    List<String> getJsonPath() {
        return jsonPath;
    }

    String getRight() {
        return rightName;
    }
}
