package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EditableData<T> {
    private final T actual;
    private final T patched;

    public EditableData(T actual) {
        this(actual, null);
    }

    public EditableData(T actual, @Nullable T patched) {
        this.actual = Objects.requireNonNull(actual);
        this.patched = patched;
    }

    public T getActual() {
        return actual;
    }

    @Nullable
    public T getPatched() {
        return patched;
    }

    public T getPatchedOrElseActual() {
        return patched != null ? patched : actual;
    }
}
