package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.model.Model;
import ru.yandex.partner.core.entity.IncomingFields;

public class IncomingApiFields<M extends Model> extends IncomingFields {
    private final Map<String, ApiField<M>> updatedApiFields;

    public IncomingApiFields(Map<String, ApiField<M>> updatedApiFields) {
        this.updatedApiFields = updatedApiFields;
    }

    public IncomingApiFields() {
        this(new HashMap<>());
    }

    public void put(String jsonName, ApiField<M> apiField) {
        updatedApiFields.put(jsonName, apiField);
        this.putUpdatedField(jsonName);
    }

    public Collection<ApiField<M>> values() {
        return updatedApiFields.values();
    }

    public boolean containsKey(String jsonName) {
        return updatedApiFields.containsKey(jsonName);
    }

    public Set<String> keySet() {
        return updatedApiFields.keySet();
    }
}
