package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.function.Supplier;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public interface ModelPath<M extends Model, V> {
    V get(M model);

    V getOrCreate(M model, Supplier<V> inst);

    void set(M model, V value);

    static <M extends Model, CM extends Model, V> ModelPathForApi<M, V>
    append(ModelPath<M, CM> path, ModelProperty<CM, V> prop) {
        return append(path, PropertyChainPath.defaultInstantiator(prop), prop);
    }

    static <M extends Model, CM extends Model, V> ModelPathForApi<M, V>
    append(ModelPath<M, CM> path, Supplier<CM> instantiator, ModelProperty<CM, V> prop) {
        return new PropertyChainPath<>(path, prop, instantiator);
    }

    static <M extends Model, V> ModelPathForApi<M, V> of(ModelProperty<M, V> prop) {
        return new PropertyChainPath<>(prop);
    }
}
