package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.model.Model;
import ru.yandex.partner.core.utils.OrderBy;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

public class QueryParamsContext<M extends Model> {
    private final Map<String, Map<Class<?>, Object>> extra = new HashMap<>();

    private final Map<String, Set<String>> rawParams;
    private final UserAuthentication userAuthentication;
    private final M modelFromAttributes;
    private final Function<String, List<OrderBy>> customSortConverter;

    public QueryParamsContext(Map<String, Set<String>> rawParams,
                              UserAuthentication userAuthentication,
                              M modelFromAttributes,
                              Function<String, List<OrderBy>> customSortConverter) {
        this.rawParams = rawParams;
        this.userAuthentication = userAuthentication;
        this.modelFromAttributes = modelFromAttributes;
        this.customSortConverter = customSortConverter;
    }

    public UserAuthentication getUserAuthentication() {
        return userAuthentication;
    }

    public M getModelFromAttributes() {
        return modelFromAttributes;
    }

    public Map<String, Set<String>> getRawParams() {
        return rawParams;
    }

    public Function<String, List<OrderBy>> getCustomSortConverter() {
        return customSortConverter;
    }

    public <P> void putExtra(String apiFieldName, Class<? extends P> paramClass, @Nullable P extraParam) {
        Map<Class<?>, Object> perField = extra.getOrDefault(apiFieldName, new HashMap<>());
        perField.put(paramClass, extraParam);
        extra.put(apiFieldName, perField);
    }

    @Nullable
    public <P> P getExtra(String apiFieldName, Class<? extends P> paramClass) {
        Map<Class<?>, Object> perField = extra.get(apiFieldName);
        if (perField == null) {
            return null;
        }
        return paramClass.cast(perField.get(paramClass));
    }
}
