package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class RequiredModelProperties {
    //поля необходимые для вычисления
    private final Set<ModelProperty<? extends Model, ?>> requiredFields = new HashSet<>();

    //поля необходимые чтобы ответить доступно поле на чтение или нет
    private final Set<ModelProperty<? extends Model, ?>> availableFields = new HashSet<>();

    //поля необходимые чтобы ответить доступно поле на редактирование или нет
    private final Set<ModelProperty<? extends Model, ?>> editableFields = new HashSet<>();

    //поля необходимые чтобы ответить доступно поле при добавлении или нет
    private final Set<ModelProperty<? extends Model, ?>> addFields = new HashSet<>();

    public RequiredModelProperties() {

    }

    public Set<ModelProperty<? extends Model, ?>> getRequiredFields() {
        return requiredFields;
    }

    public RequiredModelProperties putRequiredFields(Set<ModelProperty<? extends Model, ?>> requiredFields) {
        this.requiredFields.addAll(requiredFields);
        return this;
    }

    public Set<ModelProperty<? extends Model, ?>> getAvailableFields() {
        return availableFields;
    }

    public RequiredModelProperties putAvailableFields(Set<ModelProperty<? extends Model, ?>> availableFields) {
        this.availableFields.addAll(availableFields);
        return this;
    }

    public Set<ModelProperty<? extends Model, ?>> getEditableFields() {
        return editableFields;
    }

    public RequiredModelProperties putEditableFields(Set<ModelProperty<? extends Model, ?>> editableFields) {
        this.editableFields.addAll(editableFields);
        return this;
    }

    public Set<ModelProperty<? extends Model, ?>> getAddFields() {
        return addFields;
    }

    public RequiredModelProperties putAddFields(Set<ModelProperty<? extends Model, ?>> addFields) {
        this.addFields.addAll(addFields);
        return this;
    }
}
