package ru.yandex.partner.jsonapi.crnk.filter;

import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.authorization.decision.DecisionMatcher;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;

public final class AuthorizationFilterWrapper {
    private AuthorizationFilterWrapper() {
        // utility
    }

    @NotNull
    public static <M extends ModelWithId> CoreFilterNode<M> attachAuthorizationFilter(
            @NotNull CoreFilterNode<M> coreFilterNode, AuthorizationDecision<M> decision) {
        CoreFilterNode<M> authorizationFilterNode = decision.match(extractingPermitFilter());

        return coreFilterNode.and(authorizationFilterNode);
    }

    /**
     * UTILITY to assert PERMIT or RESTRICTED_PERMIT state and extract CoreFilterNode,
     * throw exception otherwise
     */
    public static <M extends ModelWithId> DecisionMatcher<M, CoreFilterNode<M>> extractingPermitFilter() {
        return new DecisionMatcher<>() {
            @Override
            public CoreFilterNode<M> unapplicable(Boolean unapplicable) {
                // 500 ?
                throw new IllegalStateException("No applicable request policy found");
            }

            @Override
            public CoreFilterNode<M> permit(Boolean permit) {
                return CoreFilterNode.neutral();
            }

            @Override
            public CoreFilterNode<M> restrictedPermit(CoreFilterNode<M> x) {
                return x;
            }

            @Override
            public CoreFilterNode<M> deny(String deny) {
                throw new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__NOT_FOUND);
            }
        };
    }
}
