package ru.yandex.partner.jsonapi.crnk.filter;


import io.crnk.core.queryspec.FilterSpec;

import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.filter.parser.FilterNode;

public class CrnkFilterAdapter extends FilterSpec {

    private final String filterString;
    private final FilterNode filterNode;

    public CrnkFilterAdapter(String filterString, FilterNode filterNode) {
        this.filterString = filterString;
        this.filterNode = filterNode;
    }

    CrnkFilterAdapter(CrnkFilterAdapter src) {
        this.filterString = src.filterString;
        this.filterNode = src.filterNode;
    }

    public <M> CoreFilterNode<M> toCoreFilterNode(CrnkModelFilters<M> crnkModelFilters) {
        return filterNode.toCoreFilterNode(crnkModelFilters);
    }

    public String getFilterString() {
        return filterString;
    }

    public FilterNode getFilterNode() {
        return filterNode;
    }

    @Override
    public FilterSpec clone() {
        return new CrnkFilterAdapter(this);
    }
}
