package ru.yandex.partner.jsonapi.crnk.filter;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.DictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.expose.CrnkFilterExposeStrategy;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class CrnkFilterEntity {
    private final GettextMsg label;
    private final GettextMsg hint;
    private final CrnkFilterExposeStrategy exposeStrategy;

    private final String name;
    private final String group;
    private final FilterType filterType;
    private final DictionaryValuesProvider<?> dictionaryValuesProvider;

    public CrnkFilterEntity(
            String name,
            String group,
            FilterType filterType,
            GettextMsg label,
            GettextMsg hint,
            CrnkFilterExposeStrategy exposeStrategy,
            DictionaryValuesProvider<?> dictionaryValuesProvider
    ) {
        this.name = name;
        this.group = group;
        this.filterType = filterType;
        this.label = label;
        this.hint = hint;
        this.exposeStrategy = exposeStrategy;
        this.dictionaryValuesProvider = dictionaryValuesProvider;
    }

    public GettextMsg getLabel() {
        return label;
    }

    public GettextMsg getHint() {
        return hint;
    }

    public String getName() {
        return name;
    }

    public String getGroup() {
        return group;
    }

    public FilterType getFilterType() {
        return filterType;
    }

    public DictionaryValuesProvider<?> getDictionaryValuesProvider() {
        return dictionaryValuesProvider;
    }

    public boolean isExposed() {
        return exposeStrategy.isFilterExposed();
    }
}
