package ru.yandex.partner.jsonapi.crnk.filter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.DictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.CrnkFilterValueParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.MatchCrnkFilterValueParser;

public class CrnkFilterMatch<M, V> extends CrnkFilter<M, V> {
    private final List<CrnkFilterEntity> crnkFilterEntities;

    protected CrnkFilterMatch(
            String name,
            String group,
            MetaFilter<? super M, V> metaFilter,
            CrnkFilterValueParser<V> crnkFilterValueParser,
            CrnkFilterBuilder... crnkFilterBuilders
    ) {
        super(name, group, metaFilter, crnkFilterValueParser);

        crnkFilterEntities = new ArrayList<>(crnkFilterBuilders.length);
        for (CrnkFilterBuilder crnkFilterBuilder : crnkFilterBuilders) {
            List<CrnkFilterName> crnkFilterNames = crnkFilterBuilder.getCrnkFilterNames();
            CrnkFilter<?, ?> crnkFilter = getFilterByPath(crnkFilterValueParser, new LinkedList<>(crnkFilterNames));

            this.crnkFilterEntities.add(new CrnkFilterEntity(
                    this.getName() + "." + crnkFilterNames.stream()
                            .map(CrnkFilterName::getName).collect(Collectors.joining(".")),
                    crnkFilter.getGroup(),
                    crnkFilter.getFilterType(),
                    crnkFilterBuilder.getLabel(),
                    crnkFilterBuilder.getHint(),
                    crnkFilterBuilder.getExposeStrategy(),
                    crnkFilter.getDictionaryValuesProvider()
            ));
        }
    }

    /**
     * Обходим дерево матч фильтров по заданному пути
     * и получаем ноду - тот crnkFilter на который указывает путь
     */
    private CrnkFilter<?, ?> getFilterByPath(
            CrnkFilterValueParser<?> crnkFilterValueParser,
            Queue<CrnkFilterName> path
    ) {
        var matchFilterParser = (MatchCrnkFilterValueParser<?>) crnkFilterValueParser;
        if (path.size() == 1) {
            return matchFilterParser.getFilter(path.remove().getName());
        }
        return getFilterByPath(
                matchFilterParser.getFilter(path.remove().getName()).getCrnkFilterValueParser(),
                path
        );
    }

    @Override
    public DictionaryValuesProvider<?> getDictionaryValuesProvider() {
        return null;
    }

    @Override
    public List<CrnkFilterEntity> getCrnkFilterEntities() {
        return crnkFilterEntities;
    }
}
