package ru.yandex.partner.jsonapi.crnk.filter;

import java.util.List;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.DictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.CrnkFilterValueParser;

public class CrnkFilterSimple<M, V> extends CrnkFilter<M, V> {
    private final List<CrnkFilterEntity> crnkFilterEntities;
    private final DictionaryValuesProvider<?> dictionaryValuesProvider;

    protected CrnkFilterSimple(
            CrnkFilterBuilder crnkFilterBuilder,
            MetaFilter<? super M, V> metaFilter,
            DictionaryValuesProvider<?> dictionaryValuesProvider,
            CrnkFilterValueParser<V> crnkFilterValueParser

    ) {
        super(crnkFilterBuilder.getName(), crnkFilterBuilder.getGroup(), metaFilter, crnkFilterValueParser);

        this.dictionaryValuesProvider = dictionaryValuesProvider;
        this.crnkFilterEntities = List.of(
                new CrnkFilterEntity(
                        crnkFilterBuilder.getName(),
                        crnkFilterBuilder.getGroup(),
                        metaFilter.getFilterType(),
                        crnkFilterBuilder.getLabel(),
                        crnkFilterBuilder.getHint(),
                        crnkFilterBuilder.getExposeStrategy(),
                        dictionaryValuesProvider
                )
        );
    }

    @Override
    public DictionaryValuesProvider<?> getDictionaryValuesProvider() {
        return dictionaryValuesProvider;
    }

    @Override
    public List<CrnkFilterEntity> getCrnkFilterEntities() {
        return crnkFilterEntities;
    }
}
