package ru.yandex.partner.jsonapi.crnk.filter.description;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;

public class FilterDescription implements Comparable<FilterDescription> {

    private final String name;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private final String group;

    private final String type;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private final String label;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private final String hint;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private final List<FilterDictionaryValue<?>> values;

    public FilterDescription(String name,
                             String group,
                             String type,
                             String label,
                             String hint,
                             List<FilterDictionaryValue<?>> values) {
        this.name = name;
        this.group = group;
        this.type = type;
        this.label = label;
        this.hint = hint;
        this.values = values;
    }

    public String getName() {
        return name;
    }

    public String getGroup() {
        return group;
    }

    public String getType() {
        return type;
    }

    public String getLabel() {
        return label;
    }

    public String getHint() {
        return hint;
    }

    public List<FilterDictionaryValue<?>> getValues() {
        return values;
    }

    @Override
    public int compareTo(FilterDescription that) {
        return this.name.compareTo(that.name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterDescription)) {
            return false;
        }
        FilterDescription that = (FilterDescription) o;
        return name.equals(that.name) &&
                Objects.equals(group, that.group) &&
                type.equals(that.type) &&
                Objects.equals(label, that.label) &&
                Objects.equals(hint, that.hint) &&
                Objects.equals(values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, group, type, label, hint, values);
    }

    @Override
    public String toString() {
        return "FilterDescription{" +
                "name='" + name + '\'' +
                ", group='" + group + '\'' +
                ", type='" + type + '\'' +
                ", label='" + label + '\'' +
                ", hint='" + hint + '\'' +
                ", values=" + values +
                '}';
    }
}
