package ru.yandex.partner.jsonapi.crnk.filter.description;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilterEntity;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.DictionaryValuesProvider;

@Service
public class FilterDescriptionService implements MessageSourceAware {

    private MessageSourceAccessor messages = new MessageSourceAccessor(new DelegatingMessageSource());

    @Override
    public void setMessageSource(@Nonnull MessageSource messageSource) {
        messages = new MessageSourceAccessor(messageSource);
    }

    public <M> List<FilterDescription> renderDescriptions(Collection<CrnkFilter<M, ?>> crnkFilters) {
        return crnkFilters.stream().flatMap(crnkFilter -> crnkFilter
                .getCrnkFilterEntities()
                .stream()
                .filter(CrnkFilterEntity::isExposed)
                .map(entity -> new FilterDescription(
                                entity.getName(),
                                entity.getGroup(),
                                entity.getFilterType().getText(),
                                entity.getLabel() == null ? null : messages.getMessage(entity.getLabel()),
                                entity.getHint() == null ? null : messages.getMessage(entity.getHint()),
                                entity.getDictionaryValuesProvider() == null ? null :
                                        renderDictionaryValues(entity.getDictionaryValuesProvider())
                        )
                )
        ).sorted().collect(Collectors.toList());
    }

    private List<FilterDictionaryValue<?>> renderDictionaryValues(
            DictionaryValuesProvider<?> dictionaryValuesProvider) {
        return dictionaryValuesProvider.renderValues(messages);
    }

}
