package ru.yandex.partner.jsonapi.crnk.filter.description;

import java.util.Objects;

public class FilterDictionaryValue<T extends Comparable<T>> implements Comparable<FilterDictionaryValue<T>> {
    private final T id;
    private final String label;

    public FilterDictionaryValue(T id, String label) {
        this.id = id;
        this.label = label;
    }

    public T getId() {
        return id;
    }

    public String getLabel() {
        return label;
    }

    @Override
    public int compareTo(FilterDictionaryValue<T> that) {
        return this.id.compareTo(that.id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterDictionaryValue)) {
            return false;
        }
        FilterDictionaryValue<?> that = (FilterDictionaryValue<?>) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(label, that.label);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, label);
    }

    @Override
    public String toString() {
        return "FilterDictionaryValue{" +
                "id=" + id +
                ", label='" + label + '\'' +
                '}';
    }
}
