package ru.yandex.partner.jsonapi.crnk.filter.description.provider;

import java.util.List;
import java.util.SortedMap;
import java.util.stream.Collectors;

import org.springframework.context.support.MessageSourceAccessor;

import ru.yandex.partner.jsonapi.crnk.filter.description.FilterDictionaryValue;
import ru.yandex.partner.libs.i18n.GettextMsg;

public abstract class AbstractDictionaryValuesProvider<T extends Comparable<T>> implements DictionaryValuesProvider<T> {

    /**
     * @return sorted map
     */
    protected abstract SortedMap<T, GettextMsg> getValues();

    @Override
    public List<FilterDictionaryValue<?>> renderValues(MessageSourceAccessor messages) {
        return getValues().entrySet().stream()
                .map(e -> new FilterDictionaryValue<>(e.getKey(), messages.getMessage(e.getValue())))
                .collect(Collectors.toList());
    }

}
