package ru.yandex.partner.jsonapi.crnk.filter.description.provider;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.dictionary.moderationreason.ModerationReasonService;
import ru.yandex.partner.jsonapi.crnk.filter.description.FilterDictionaryValue;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

import static ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum.MODERATION_REASON_MANAGER_TXT_VIEW;

@Component
public class ModerationReasonDictionaryValuesProvider implements DictionaryValuesProvider<Long> {

    private final ModerationReasonService moderationReasonService;
    private final AuthenticationFacade authenticationFacade;

    public ModerationReasonDictionaryValuesProvider(ModerationReasonService moderationReasonService,
                                                    AuthenticationFacade authenticationFacade) {
        this.moderationReasonService = moderationReasonService;
        this.authenticationFacade = authenticationFacade;
    }

    @Override
    public List<FilterDictionaryValue<?>> renderValues(MessageSourceAccessor messages) {
        UserAuthentication ua = authenticationFacade.getUserAuthentication();

        return getDictionaryValues(ua);
    }

    public List<FilterDictionaryValue<?>> getDictionaryValues(UserAuthentication ua) {
        String language = LocaleContextHolder.getLocale().getLanguage();
        boolean isManager = ua.userHasRight(MODERATION_REASON_MANAGER_TXT_VIEW);

        Map<Long, String> dictionaryValues = new TreeMap<>(
                moderationReasonService.getDictionaryValues(language, isManager)
        );

        return dictionaryValues.entrySet().stream()
                .map(e -> new FilterDictionaryValue<>(e.getKey(), e.getValue())).collect(Collectors.toList());
    }
}
