package ru.yandex.partner.jsonapi.crnk.filter.description.provider;

import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.jsonapi.utils.MergeUtils;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class MultistateDictionaryValuesProvider<T extends Enum<T> & StateFlag>
        extends AbstractDictionaryValuesProvider<String> {

    private final SortedMap<String, GettextMsg> valuesMsgMap;

    public MultistateDictionaryValuesProvider(Class<T> stateFlagClass) {
        valuesMsgMap = Arrays.stream(stateFlagClass.getEnumConstants())
                .filter(flag -> !flag.isPrivate())
                .collect(Collectors.toMap(
                        flag -> flag.name().toLowerCase(),
                        StateFlag::getMsg,
                        MergeUtils.uniqMerge(),
                        TreeMap::new
                ));
    }

    @Override
    protected SortedMap<String, GettextMsg> getValues() {
        return valuesMsgMap;
    }

}
