package ru.yandex.partner.jsonapi.crnk.filter.description.provider;

import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.role.Role;
import ru.yandex.partner.jsonapi.utils.MergeUtils;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.rbac.role.RoleRepository;

@Service
public class RolesDictionaryValuesProvider extends AbstractDictionaryValuesProvider<Long> {

    private final SortedMap<Long, GettextMsg> map;

    public RolesDictionaryValuesProvider() {
        map = RoleRepository.getRoles().stream()
                .collect(Collectors.toMap(
                        Role::getRoleId,
                        Role::getNameMsg,
                        MergeUtils.uniqMerge(),
                        TreeMap::new));
    }

    @Override
    protected SortedMap<Long, GettextMsg> getValues() {
        return map;
    }
}
