package ru.yandex.partner.jsonapi.crnk.filter.description.provider;

import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.user.filter.UserType;
import ru.yandex.partner.jsonapi.utils.MergeUtils;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.i18n.GettextMsg;

@Service
public class UserTypeDictionaryValuesProvider extends AbstractDictionaryValuesProvider<Long> {

    private final AuthenticationFacade authenticationFacade;

    public UserTypeDictionaryValuesProvider(AuthenticationFacade authenticationFacade) {
        this.authenticationFacade = authenticationFacade;
    }

    @Override
    protected SortedMap<Long, GettextMsg> getValues() {
        return Arrays.stream(UserType.values())
                .filter(userType -> userType.getViewRightName() == null
                        || authenticationFacade.userHasRight(userType.getViewRightName()))
                .collect(Collectors.toMap(
                        UserType::getId,
                        UserType::getLabel,
                        MergeUtils.uniqMerge(),
                        TreeMap::new
                ));
    }

}
