package ru.yandex.partner.jsonapi.crnk.filter.expose;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.partner.libs.auth.RightHolder;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

import static java.util.Objects.requireNonNull;

public class CheckRightsCrnkFilterExposeStrategy implements CrnkFilterExposeStrategy {

    private final AuthenticationFacade authenticationFacade;
    private final List<String> rights;

    public CheckRightsCrnkFilterExposeStrategy(AuthenticationFacade authenticationFacade, List<String> rights) {
        requireNonNull(authenticationFacade);
        requireNonNull(rights);
        this.authenticationFacade = authenticationFacade;
        this.rights = rights;
    }

    public boolean isFilterExposed() {
        return rights.stream().allMatch(authenticationFacade::userHasRight);
    }

    public static class Factory {

        private final AuthenticationFacade authenticationFacade;

        public Factory(AuthenticationFacade authenticationFacade) {
            this.authenticationFacade = authenticationFacade;
        }

        public CheckRightsCrnkFilterExposeStrategy forRights(RightHolder... rights) {
            List<RightHolder> rightsList = Arrays.asList(rights);
            return new CheckRightsCrnkFilterExposeStrategy(
                    authenticationFacade,
                    rightsList.stream().map(RightHolder::getRightName)
                            .collect(Collectors.toList())
            );
        }
    }

}
