package ru.yandex.partner.jsonapi.crnk.filter.parser;

import java.util.Objects;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.core.filter.CoreFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.CrnkFilterParserException;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.IgnorableFilterParserException;
import ru.yandex.partner.jsonapi.messages.ControllerMsg;

class RawFilter {
    private final String name;
    private final FilterOperator filterOperator;
    private final JsonNode value;

    RawFilter(String name, FilterOperator filterOperator, JsonNode value) {
        this.name = Objects.requireNonNull(name);
        this.filterOperator = Objects.requireNonNull(filterOperator);
        this.value = Objects.requireNonNull(value);
    }

    <M> CoreFilter<M> toCoreFilter(CrnkModelFilters<? super M> crnkModelFilters) throws IgnorableFilterParserException {
        CrnkFilter<M, ?> crnkFilter = verifiedFilter(crnkModelFilters, name);
        return crnkFilter.toCoreFilter(filterOperator, value);
    }

    private <M> CrnkFilter<M, ?> verifiedFilter(CrnkModelFilters<? super M> crnkModelFilters, String filterName) {
        CrnkFilter<? super M, ?> filter = crnkModelFilters.getFilters().get(filterName);
        if (filter == null) {
            throw new CrnkFilterParserException(
                    "Filter not found. FilterName = " + filterName,
                    ControllerMsg.PARAMETER_FILTER_INCORRECT
            );
        }
        return (CrnkFilter<M, ?>) filter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RawFilter)) {
            return false;
        }
        RawFilter rawFilter = (RawFilter) o;
        return name.equals(rawFilter.name) &&
                filterOperator == rawFilter.filterOperator &&
                value.equals(rawFilter.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, filterOperator, value);
    }
}
