package ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions;

import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class CrnkFilterParserException extends CrnkResponseStatusException {

    public CrnkFilterParserException(GettextMsg externalMessage) {
        super(HttpErrorStatusEnum.ERROR__PARAMS, externalMessage);
    }

    public CrnkFilterParserException(String internalMessage, GettextMsg externalMessage) {
        super(HttpErrorStatusEnum.ERROR__PARAMS, externalMessage, internalMessage);
    }

    public CrnkFilterParserException(Throwable cause, GettextMsg externalMessage) {
        super(HttpErrorStatusEnum.ERROR__PARAMS, externalMessage, cause);
    }

    public CrnkFilterParserException(String internalMessage, Throwable cause, GettextMsg externalMessage) {
        super(HttpErrorStatusEnum.ERROR__PARAMS, externalMessage, internalMessage, cause);
    }
}
