package ru.yandex.partner.jsonapi.crnk.filter.parser.values;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.core.service.integration.balance.BalanceDocumentService;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.IgnorableFilterParserException;
import ru.yandex.partner.libs.extservice.balance.method.partnercontract.BalancePartnerContract;

public class ContractNumberCrnkFilterValueParser implements CrnkFilterValueParser<Long> {
    private final BalanceDocumentService balanceDocumentService;
    private final CrnkFilterValueParser<String> valueParser;

    public ContractNumberCrnkFilterValueParser(BalanceDocumentService balanceDocumentService) {
        this.balanceDocumentService = balanceDocumentService;
        this.valueParser = new DefaultCrnkFilterValueParser<>(String.class);
    }

    @Override
    public Collection<Long> toValues(JsonNode node) throws IgnorableFilterParserException {
        Collection<String> values = valueParser.toValues(node);
        return values.stream()
                .flatMap(value -> balanceDocumentService.getPartnerContracts(value).stream())
                .map(BalancePartnerContract::getPerson)
                .filter(Optional::isPresent)
                .map(person -> person.get().getClientId())
                .collect(Collectors.toSet());
    }
}
