package ru.yandex.partner.jsonapi.crnk.filter.parser.values;

import java.util.Collection;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.CrnkFilterIncorrectException;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.IgnorableFilterParserException;

public class FlexibleBooleanCrnkFilterValueParser implements CrnkFilterValueParser<Boolean> {

    private final CrnkFilterValueParser<Boolean> booleanParser;
    private final CrnkFilterValueParser<String> stringParser;

    public FlexibleBooleanCrnkFilterValueParser() {
        this.booleanParser = new DefaultCrnkFilterValueParser<>(Boolean.class);
        this.stringParser = new DefaultCrnkFilterValueParser<>(String.class);
    }

    @Override
    public Collection<Boolean> toValues(JsonNode node) throws IgnorableFilterParserException {
        if (node.isBoolean()) {
            return booleanParser.toValues(node);
        }

        return stringParser.toValues(node).stream().map(string -> {
            if ("1".equals(string)) {
                return true;
            } else if ("0".equals(string) || "".equals(string)) {
                return false;
            }
            throw new CrnkFilterIncorrectException("Cannot parse values");
        }).collect(Collectors.toSet());
    }

}
