package ru.yandex.partner.jsonapi.crnk.filter.parser.values;

import java.util.Collection;
import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.FilterNode;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

import static ru.yandex.partner.jsonapi.crnk.filter.AuthorizationFilterWrapper.attachAuthorizationFilter;

public class MatchCrnkFilterValueParser<M extends ModelWithId> implements CrnkFilterValueParser<CoreFilterNode<M>> {

    private final CrnkFilterParser crnkFilterParser;
    private final CrnkModelFilters<M> crnkModelFilters;
    private final RequestAuthorizationService requestAuthorizationService;
    private final Policy<M> policy;

    public MatchCrnkFilterValueParser(
            CrnkFilterParser crnkFilterParser,
            RequestAuthorizationService requestAuthorizationService,
            CrnkModelFilters<? extends M> crnkModelFilters,
            Policy<? extends M> policy
    ) {
        this.crnkFilterParser = crnkFilterParser;
        //noinspection unchecked
        this.crnkModelFilters = (CrnkModelFilters<M>) crnkModelFilters;
        this.requestAuthorizationService = requestAuthorizationService;
        //noinspection unchecked
        this.policy = (Policy<M>) policy;
    }

    @Override
    public Collection<CoreFilterNode<M>> toValues(JsonNode jsonNode) {
        FilterNode filterNode = crnkFilterParser.parse(jsonNode);

        CoreFilterNode<M> coreFilterNode = filterNode.toCoreFilterNode(crnkModelFilters);

        coreFilterNode = attachAuthorizationFilter(
                coreFilterNode, policy.authorizeGetAllRequest(requestAuthorizationService.currentRequestContext())
        );

        return List.of(coreFilterNode);
    }

    /**
     * Достаем фильтр по его имени из множества фильтров, доступных для парсинга
     */
    public CrnkFilter<?, ?> getFilter(String name) {
        return Optional.of(crnkModelFilters)
                .map(CrnkModelFilters::getFilters)
                .map(m -> m.get(name))
                .orElseThrow(() ->
                    new IllegalArgumentException("Can not find filter with name %s in %s"
                            .formatted(name, crnkModelFilters.getClass().getName()))
                );
    }
}
