package ru.yandex.partner.jsonapi.crnk.kvstorefrontend;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ForeignFieldDefaultsService;
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite;
import ru.yandex.partner.jsonapi.models.kvstorefrontend.ApiKvFrontendModel;

@ParametersAreNonnullByDefault
@Component
public class KvStoreFrontendApiFieldsService extends ApiFieldsService<KvStoreFrontend> {

    @Autowired
    public KvStoreFrontendApiFieldsService(
            ApiKvFrontendModel apiKvFrontendModel,
            List<ForeignFieldDefaultsService<KvStoreFrontend>> foreignFieldDefaultsServices) {
        super(apiKvFrontendModel.getApiFieldsAvailableRules(), apiKvFrontendModel.getApiFieldsEditableRules(),
                apiKvFrontendModel, CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME,
                CrnkConstants.EDITABLE_FIELDS_FIELD_NAME, new CommonFunctionComposite<>(),
                foreignFieldDefaultsServices);
    }

    @Override
    public ModelProperty<? super KvStoreFrontend, ?> getId() {
        return KvStoreFrontend.ID;
    }

    @Override
    public Set<ModelProperty<?, ?>> getPropertiesForValidate(Set<ModelProperty<?, ?>> affectedFields) {
        return Set.of();
    }
}
