package ru.yandex.partner.jsonapi.crnk.kvstorefrontend.authorization;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@ParametersAreNonnullByDefault
@Component
public class KvStoreEditAllRule {
    public AuthorizationDecision<KvStoreFrontend> authorize(UserAuthentication ua) {
        return ua.userHasRight(KvStoreFrontendRightsEnum.EDIT_ALL)
                ? AuthorizationDecision.permit()
                : AuthorizationDecision.unapplicable();
    }
}
