package ru.yandex.partner.jsonapi.crnk.kvstorefrontend.authorization;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.auth.RightHolder;

@ParametersAreNonnullByDefault
public enum KvStoreFrontendRightsEnum implements RightHolder {
    VIEW_ALL("kv_store_frontend_view_all"),
    EDIT_ALL("kv_store_frontend_edit_all");

    private final String rightName;

    KvStoreFrontendRightsEnum(String rightName) {
        this.rightName = rightName;
    }

    @Override
    public String getRightName() {
        return rightName;
    }


}
