package ru.yandex.partner.jsonapi.crnk.kvstorefrontend.authorization;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.filter.KvStoreFrontendFilters;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@ParametersAreNonnullByDefault
@Component
public class KvStoreOwnerEditRule {
    public AuthorizationDecision<KvStoreFrontend> authorize(UserAuthentication ua) {
        return AuthorizationDecision.restrictedPermit(
                CoreFilterNode.eq(KvStoreFrontendFilters.USER_ID, ua.getUid())
        );
    }

    public AuthorizationDecision<KvStoreFrontend> authorize(UserAuthentication ua, KvStoreFrontend entity) {
        return Objects.equals(ua.getUid(), entity.getUserId())
                ? AuthorizationDecision.permit()
                : AuthorizationDecision.deny(
                "Key-value entry " + entity + " isn't owned by user " + ua.getUid()
        );
    }
}
