package ru.yandex.partner.jsonapi.crnk.kvstorefrontend.authorization;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.filter.KvStoreFrontendFilters;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@ParametersAreNonnullByDefault
@Component
public class KvStoreOwnerViewRule {

    public AuthorizationDecision<KvStoreFrontend> authorize(UserAuthentication ua) {
        MetaFilter<KvStoreFrontend, Long> metaFilter = KvStoreFrontendFilters.USER_ID;

        return AuthorizationDecision.restrictedPermit(
                CoreFilterNode.create(metaFilter, FilterOperator.IN, List.of(ua.getUid(), 0L))
        );
    }
}
