package ru.yandex.partner.jsonapi.crnk.kvstorefrontend.authorization;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

import static ru.yandex.partner.jsonapi.crnk.kvstorefrontend.authorization.KvStoreFrontendRightsEnum.VIEW_ALL;

@ParametersAreNonnullByDefault
@Component
public class KvStoreViewAllRule {

    public AuthorizationDecision<KvStoreFrontend> authorize(UserAuthentication ua) {
        return (ua.userHasRight(VIEW_ALL))
                ? AuthorizationDecision.permit()
                : AuthorizationDecision.unapplicable();
    }
}
