package ru.yandex.partner.jsonapi.crnk.multistate;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

public class ActionName implements Comparable<ActionName> {
    private final String actionName;
    private final String apiActionName;

    public ActionName(String actionName) {
        this(actionName, actionName);
    }

    public ActionName(String actionName, String apiActionName) {
        this.actionName = actionName;
        this.apiActionName = apiActionName;
    }

    public String getActionName() {
        return actionName;
    }

    public String getApiActionName() {
        return apiActionName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionName)) {
            return false;
        }
        ActionName that = (ActionName) o;
        return actionName.equals(that.actionName) &&
                apiActionName.equals(that.apiActionName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(actionName, apiActionName);
    }

    @Override
    public int compareTo(@NotNull ActionName actionName) {
        return apiActionName.compareTo(actionName.getApiActionName());
    }

    @Override
    public String toString() {
        // method is used by jackson for serialize
        return apiActionName;
    }
}
