package ru.yandex.partner.jsonapi.crnk.multistate;

import org.mapstruct.Mapper;
import org.mapstruct.Named;
import org.mapstruct.ReportingPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.multistate.Multistate;

@Mapper(componentModel = "spring", unmappedTargetPolicy = ReportingPolicy.IGNORE)
@Component
@SuppressWarnings("unused")
public class CommonMultistateCrnkMapper {

    public static final String MULTISTATE_TO_MULTISTATE_NAME = "multistateToMultistateName";

    private MultistateService multistateService;

    @Autowired
    public void setMultistateService(MultistateService multistateService) {
        this.multistateService = multistateService;
    }

    public Long multistateToMultistateValue(Multistate<?> multistate) {
        return multistate == null ? null : multistate.toMultistateValue();
    }

    @Named(MULTISTATE_TO_MULTISTATE_NAME)
    public String multistateToMultistateName(Multistate<?> multistate) {
        if (multistate == null) {
            return null;
        }
        return multistateService != null ? multistateService.renderMultistateName(multistate) :
                multistate.toString();
    }

}
