package ru.yandex.partner.jsonapi.crnk.multistate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.action.Action;
import ru.yandex.partner.core.multistate.Multistate;

@Service
public class MultistateService implements MessageSourceAware {
    private static final String DELETE = "delete";
    private static final String ARCHIVE = "archive";
    protected MessageSourceAccessor messages = new MessageSourceAccessor(new DelegatingMessageSource());

    @Override
    @Autowired
    public void setMessageSource(@Nonnull MessageSource messageSource) {
        messages = new MessageSourceAccessor(messageSource);
    }

    public String renderMultistateName(Multistate<?> multistate) {
        return multistate.getNameMessages().stream()
                .map(msg -> messages.getMessage(msg))
                .collect(Collectors.joining(".\n"));
    }

    public Map<ActionName, String> renderActions(Set<Action> actions) {
        if (actions == null) {
            return Collections.emptyMap();
        }

        Map<ActionName, String> actionMap = Maps.newHashMapWithExpectedSize(actions.size());

        for (Action action : actions) {
            String label = action.getTitle() != null ? messages.getMessage(action.getTitle()) : action.getName();
            actionMap.put(new ActionName(action.getName()), label);
        }

        ActionName toBeRemoved = new ActionName(DELETE);
        ActionName replacement = new ActionName(DELETE, ARCHIVE);
        if (actionMap.containsKey(toBeRemoved)) {
            actionMap.put(replacement, actionMap.remove(toBeRemoved));
        }

        return actionMap;
    }

    public String getApiActionName(String actionName) {
        if (DELETE.equals(actionName)) {
            return ARCHIVE;
        } else {
            return actionName;
        }
    }

}
