package ru.yandex.partner.jsonapi.crnk.page;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.page.model.PageWithPageID;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ForeignFieldDefaultsService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite;

import static ru.yandex.partner.core.entity.page.model.prop.BasePageIdPropHolder.ID;

public class PageApiFieldsService<T extends PageWithPageID> extends ApiFieldsService<T> {

    private final PageValidationTypeSupportFacade pageValidationTypeSupportFacade;

    public PageApiFieldsService(ApiModel<T> apiModel,
                                List<ForeignFieldDefaultsService<T>> foreignFieldDefaultsServices,
                                PageValidationTypeSupportFacade pageValidationTypeSupportFacade) {
        super(
                apiModel.getApiFieldsAvailableRules(),
                apiModel.getApiFieldsEditableRules(),
                apiModel,
                CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME,
                CrnkConstants.EDITABLE_FIELDS_FIELD_NAME,
                new CommonFunctionComposite<>(),
                foreignFieldDefaultsServices
        );
        this.pageValidationTypeSupportFacade = pageValidationTypeSupportFacade;
    }


    @Override
    public ModelProperty<? super T, ?> getId() {
        return ID;
    }

    @Override
    public Set<ModelProperty<?, ?>> getPropertiesForValidate(Set<ModelProperty<?, ?>> affectedFields) {
        return pageValidationTypeSupportFacade.getPropertiesForValidate(
                affectedFields,
                getApiModel().getModelClass()
        );
    }
}
