package ru.yandex.partner.jsonapi.crnk.page;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.multistate.page.PageMultistate;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

@Service
public class PageComputableApiFieldsService {

    private final AuthenticationFacade authenticationFacade;

    public PageComputableApiFieldsService(AuthenticationFacade authenticationFacade) {
        this.authenticationFacade = authenticationFacade;
    }

    public Boolean curUserIsReadAssistant(List<Assistant> assistants) {
        if (assistants == null) {
            return null;
        }
        for (Assistant assistant : assistants) {
            if (assistant.getUserId() == authenticationFacade.getUserAuthentication().getUid()) {
                return !assistant.getCanEdit();
            }
        }
        return false;
    }

    public Boolean isProtected(PageMultistate multistate) {
        return multistate == null ? null : multistate.test(PageStateFlag.PROTECTED);
    }
}
