package ru.yandex.partner.jsonapi.crnk.page;

import java.util.List;
import java.util.Set;

import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;
import org.mapstruct.ReportingPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.multistate.page.PageMultistate;
import ru.yandex.partner.core.page.MobileStoreType;
import ru.yandex.partner.jsonapi.crnk.multistate.CommonMultistateCrnkMapper;
import ru.yandex.partner.jsonapi.crnk.page.models.ContextPageForBlockCrnk;
import ru.yandex.partner.jsonapi.crnk.page.models.InternalContextPageForBlockCrnk;
import ru.yandex.partner.jsonapi.crnk.page.models.InternalMobileAppForBlockCrnk;
import ru.yandex.partner.jsonapi.crnk.page.models.MobileAppSettingsForBlockCrnk;
import ru.yandex.partner.jsonapi.crnk.user.RoleCrnkMapper;

/**
 * Интефейс для библиотеки MapStruct
 * Доки библиотеки: https://mapstruct.org/documentation/stable/reference/html/#mapping-object-references
 */
@Mapper(
        componentModel = "spring", unmappedTargetPolicy = ReportingPolicy.IGNORE,
        uses = {RoleCrnkMapper.class, CommonMultistateCrnkMapper.class}
)
@Component
@SuppressWarnings("unused")
public abstract class PageCrnkMapper {

    private PageComputableApiFieldsService pageComputableApiFieldsService;

    @Autowired
    public void setPageHelperService(PageComputableApiFieldsService pageComputableApiFieldsService) {
        this.pageComputableApiFieldsService = pageComputableApiFieldsService;
    }

    @Mapping(source = "owner.login", target = "login")
    @Mapping(source = "assistants", target = "curUserIsReadAssistant", qualifiedByName = "curUserIsReadAssistant")
    @Mapping(source = "multistate", target = "isProtected", qualifiedByName = "mapIsProtected")
    @Mapping(source = "id", target = "id", qualifiedByName = "mapId")
    public abstract ContextPageForBlockCrnk contextPageToContextPageForBlockCrnk(ContextPage contextPage,
                                                                                 @Context Set<String> requestedFields);

    @Mapping(source = "owner.login", target = "login")
    @Mapping(source = "multistate", target = "isProtected", qualifiedByName = "mapIsProtected")
    @Mapping(source = "id", target = "id", qualifiedByName = "mapId")
    public abstract MobileAppSettingsForBlockCrnk mobileAppSettingsToMobileAppSettingsForBlockCrnk(
            MobileAppSettings mobileAppSettings, @Context Set<String> requestedFields);


    @Mapping(source = "multistate", target = "isProtected", qualifiedByName = "mapIsProtected")
    @Mapping(source = "id", target = "id", qualifiedByName = "mapId")
    @Mapping(source = "domain", target = "caption")
    @Mapping(source = "managerIds", target = "isMy", qualifiedByName = "isMy")
    @Mapping(source = "domainId", target = "siteId")
    public abstract InternalContextPageForBlockCrnk internalContextPageToInternalContextPageForBlockCrnk(
            InternalContextPage internalContextPage, @Context Set<String> requestedFields, @Context long uid);

    @Mapping(source = "multistate", target = "isProtected", qualifiedByName = "mapIsProtected")
    @Mapping(source = "id", target = "id", qualifiedByName = "mapId")
    @Mapping(source = "type", target = "typeName", qualifiedByName = "typeName")
    @Mapping(source = "managerIds", target = "isMy", qualifiedByName = "isMy")
    public abstract InternalMobileAppForBlockCrnk internalMobileAppToInternalMobileAppForBlockCrnk(
            InternalMobileApp internalMobileApp, @Context Set<String> requestedFields, @Context long uid);

    @Named("curUserIsReadAssistant")
    protected Boolean curUserIsReadAssistant(List<Assistant> assistants) {
        return pageComputableApiFieldsService.curUserIsReadAssistant(assistants);
    }

    @Named("mapIsProtected")
    protected Boolean isProtected(PageMultistate multistate) {
        return pageComputableApiFieldsService.isProtected(multistate);
    }

    @Named("mapId")
    protected String id(Long id) {
        return id.toString();
    }

    @Named("isMy")
    protected Boolean isMy(List<Long> managerIds, @Context long uid) {
        if (managerIds == null) {
            return null;
        }
        return managerIds.contains(uid);
    }

    @Named("typeName")
    protected String typeName(Long type) {
        return MobileStoreType.getById(type).getCaption();
    }
}
