package ru.yandex.partner.jsonapi.crnk.page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.domain.filter.DomainFilters;
import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilterName;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.MatchCrnkFilterValueParser;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

@Service
public class PageCrnkModelFilters implements CrnkModelFilters<ContextPage> {

    private final Map<String, CrnkFilter<ContextPage, ?>> filters = new HashMap<>();

    private final CrnkFilterParser crnkFilterParser;
    private final RequestAuthorizationService requestAuthorizationService;

    @Autowired
    public PageCrnkModelFilters(CrnkFilterParser crnkFilterParser,
                                RequestAuthorizationService requestAuthorizationService) {
        this.crnkFilterParser = crnkFilterParser;
        this.requestAuthorizationService = requestAuthorizationService;
        initFilters();
    }

    @Override
    public Map<String, CrnkFilter<ContextPage, ?>> getFilters() {
        return filters;
    }

    private void initFilters() {
        MatchCrnkFilterValueParser<BaseDomain> domainMatchCrnkFilterValueParser =
                new MatchCrnkFilterValueParser<>(
                        crnkFilterParser,
                        requestAuthorizationService,
                        () -> Map.of(
                                FilterNameEnum.DOMAIN.getName(),
                                CrnkFilter.builder(FilterNameEnum.DOMAIN)
                                        .toCrnkFilter(DomainFilters.DOMAIN)
                        ),
                        new Policy<>() {
                            @Override
                            public AuthorizationDecision<BaseDomain>
                            authorizeGetAllRequest(RequestContext getAllRequest) {
                                return AuthorizationDecision.permit();
                            }
                        }
                );

        List<CrnkFilter<? super ContextPage, ?>> filtersList = List.of(
                CrnkFilter.builder(FilterNameEnum.ID)
                        .toCrnkFilter(PageFilters.PAGE_ID),
                CrnkFilter.builder(FilterNameEnum.CAPTION)
                        .toCrnkFilter(PageFilters.CAPTION),
                CrnkFilter.builder(FilterNameEnum.ALL_DOMAIN)
                        .toCrnkFilter(PageFilters.ALL_DOMAIN),
                CrnkFilter.builder(FilterNameEnum.PAGE_ID)
                        .toCrnkFilter(PageFilters.PAGE_ID),
                CrnkFilter.builder(FilterNameEnum.DOMAIN)
                        .toCrnkFilterMatch(
                                PageFilters.DOMAIN,
                                domainMatchCrnkFilterValueParser,
                                CrnkFilter.builder(FilterNameEnum.DOMAIN)
                                        .setExposed(() -> true)
                        )
        );

        filtersList.forEach(filter -> filters.put(filter.getName(), (CrnkFilter<ContextPage, ?>) filter));
    }

    public enum FilterNameEnum implements CrnkFilterName {
        CAPTION("caption"),
        ALL_DOMAIN("all_domain"),
        PAGE_ID("page_id"),
        DOMAIN("domain"),
        ID("id");

        private final String name;

        FilterNameEnum(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return name;
        }
    }
}
