package ru.yandex.partner.jsonapi.crnk.page;

import ru.yandex.partner.libs.auth.RightHolder;

public enum PageRightsEnum implements RightHolder {
    VIEW_ALL("%s_view_all"),
    VIEW_FIELD__LOGIN("%s_view_field__login"),
    VIEW_FIELD__DOMAIN_ID("%s_view_field__domain_id"),
    EDIT_FIELD__PARTNER_READ_ONLY("%s_edit_field__partner_read_only");


    private final String rightName;

    PageRightsEnum(String rightName) {
        this.rightName = rightName;
    }

    @Override
    public String getRightName() {
        return rightName;
    }

    @Override
    public String getFullRightName(String modelName) {
        return String.format(rightName, modelName);
    }
}
