package ru.yandex.partner.jsonapi.crnk.page.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.page.mobile.internal.ApiInternalMobileAppMetaData;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

@Component
public class InternalMobileAppAuthorizationPolicy implements Policy<InternalMobileApp> {
    private final ApiModelMetaData<InternalMobileApp> internalContextMetaData;
    private final InternalPageViewAllRule internalPageViewAllRule;

    @Autowired
    public InternalMobileAppAuthorizationPolicy(ApiInternalMobileAppMetaData internalContextMetaData,
                                                InternalPageViewAllRule internalPageViewAllRule) {
        this.internalContextMetaData = internalContextMetaData;
        this.internalPageViewAllRule = internalPageViewAllRule;
    }

    @Override
    public AuthorizationDecision<InternalMobileApp> authorizeGetRequest(RequestContext getRequest) {
        return AuthorizationDecision.firstApplicable(
                internalPageViewAllRule.authorize(internalContextMetaData.getResourceType(),
                        getRequest.getUserAuthentication()),
                AuthorizationDecision.permit()
        );
    }
}
