package ru.yandex.partner.jsonapi.crnk.page.authorization;

import java.util.Objects;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalPageWithManagers;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.page.PageRightsEnum;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.rbac.role.RoleSet;

@Component
public class InternalPageViewAllRule {

    public <P extends InternalPageWithManagers> AuthorizationDecision<P> authorize(String model,
                                                                                   UserAuthentication ua) {
        String rightName = PageRightsEnum.VIEW_ALL.getFullRightName(model);
        CoreFilterNode<P> viewAllCoreFilterNode;
        if (!ua.userHasRight(rightName)) {
            viewAllCoreFilterNode = PageFilters.MANAGER_ID.eq(ua.getUid());
        } else {
            viewAllCoreFilterNode = null;
        }

        CoreFilterNode<P> robotAssistantCoreFilterNode;
        if (ua.userHasRole(RoleSet.ROBOT_ASSISTANT)) {
            robotAssistantCoreFilterNode = PageFilters.CREATOR_ID.eq(ua.getUid());
        } else {
            robotAssistantCoreFilterNode = null;
        }

        if (viewAllCoreFilterNode == null && robotAssistantCoreFilterNode == null) {
            return AuthorizationDecision.unapplicable();
        } else {
            return AuthorizationDecision.restrictedPermit(
                    CoreFilterNode.and(
                            Objects.requireNonNullElse(viewAllCoreFilterNode, CoreFilterNode.neutral()),
                            Objects.requireNonNullElse(robotAssistantCoreFilterNode, CoreFilterNode.neutral())
                    )
            );
        }
    }
}
