package ru.yandex.partner.jsonapi.crnk.page.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.jsonapi.models.page.mobile.external.ApiMobileAppSettingsMetaData;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.actioncontext.AuthParam;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

@Component
public class MobileAppSettingsAuthorizationPolicy implements Policy<MobileAppSettings> {
    public static final AuthParam<Boolean> ASSISTANT_CAN_EDIT =
            AuthParam.create("assistant_can_edit", Boolean.class);

    private final ApiMobileAppSettingsMetaData apiMobileAppSettingsMetaData;
    private final PageViewAllRule pageViewAllRule;
    private final PageOwnerRule pageOwnerRule;
    private final PageTutbyPartnersRule pageTutbyPartnersRule;
    private final PageAssistantRule pageAssistantRule;

    @Autowired
    public MobileAppSettingsAuthorizationPolicy(ApiMobileAppSettingsMetaData apiMobileAppSettingsMetaData,
                                                PageViewAllRule pageViewAllRule,
                                                PageOwnerRule pageOwnerRule,
                                                PageTutbyPartnersRule pageTutbyPartnersRule,
                                                PageAssistantRule pageAssistantRule) {
        this.apiMobileAppSettingsMetaData = apiMobileAppSettingsMetaData;
        this.pageViewAllRule = pageViewAllRule;
        this.pageOwnerRule = pageOwnerRule;
        this.pageTutbyPartnersRule = pageTutbyPartnersRule;
        this.pageAssistantRule = pageAssistantRule;
    }

    @Override
    public AuthorizationDecision<MobileAppSettings> authorizeGetRequest(RequestContext getRequest) {
        Boolean assistantCanEdit = getRequest.getParam(ASSISTANT_CAN_EDIT);

        UserAuthentication userAuthentication = getRequest.getUserAuthentication();
        return AuthorizationDecision.firstApplicable(
                pageViewAllRule.authorize(apiMobileAppSettingsMetaData.getResourceType(), userAuthentication),
                AuthorizationDecision.permitOverrides(
                        pageOwnerRule.authorize(userAuthentication),
                        pageTutbyPartnersRule.authorize(userAuthentication),
                        assistantCanEdit == null ? pageAssistantRule.authorize(userAuthentication)
                                : pageAssistantRule.authorizeCanEdit(userAuthentication, assistantCanEdit)
                )
        );
    }
}
