package ru.yandex.partner.jsonapi.crnk.page.authorization;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.filter.AssistantFilters;
import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

import static ru.yandex.partner.core.filter.CoreFilterNode.eq;
import static ru.yandex.partner.core.filter.CoreFilterNode.match;

@Component
public class PageAssistantRule {

    public AuthorizationDecision<BasePage> authorize(UserAuthentication ua) {
        if (!ua.userHasRight(UserRightsEnum.IS_ASSISTANT.getRightName())) {
            return AuthorizationDecision.unapplicable();
        }

        return AuthorizationDecision.restrictedPermit(match(
                PageFilters.ASSISTANTS,
                isActiveAssistantFilter(ua)
        ));
    }

    private CoreFilterNode<Assistant> isActiveAssistantFilter(UserAuthentication ua) {
        return eq(AssistantFilters.USER_ID, ua.getUid()).and(eq(AssistantFilters.DISSABLED, false));
    }

    public AuthorizationDecision<BasePage> authorizeCanEdit(UserAuthentication ua, boolean canEdit) {
        if (!ua.userHasRight(UserRightsEnum.IS_ASSISTANT.getRightName())) {
            return AuthorizationDecision.unapplicable();
        }

        var assistantWithEditRightFilter = isActiveAssistantFilter(ua)
                .and(AssistantFilters.CAN_EDIT.eq(canEdit));

        return AuthorizationDecision.restrictedPermit(match(
                PageFilters.ASSISTANTS,
                assistantWithEditRightFilter
        ));
    }
}
