package ru.yandex.partner.jsonapi.crnk.page.authorization;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.rbac.role.RoleSet;

@Component
public class PageOwnerRule {

    public <P extends BasePage> AuthorizationDecision<P> authorize(UserAuthentication ua) {
        MetaFilter<? super P, Long> filterHolder =
                ua.userHasRole(RoleSet.ROBOT_ASSISTANT)
                        ? PageFilters.CREATOR_ID
                        : PageFilters.OWNER_ID;

        return AuthorizationDecision.restrictedPermit(
                CoreFilterNode.create(filterHolder, FilterOperator.EQUALS, ua.getUid())
        );
    }
}
