package ru.yandex.partner.jsonapi.crnk.page.authorization;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class PageTutbyPartnersRule {

    public <P extends BasePage> AuthorizationDecision<P> authorize(UserAuthentication ua) {
        if (ua.userHasRight(UserRightsEnum.VIEW_ALL_TUTBY_PARTNERS.getRightName())) {
            return AuthorizationDecision.restrictedPermit(
                    CoreFilterNode.create(
                            PageFilters.OWNER,
                            FilterOperator.MATCH,
                            CoreFilterNode.create(
                                    UserFilters.IS_TUTBY,
                                    FilterOperator.EQUALS,
                                    true
                            )
                    )
            );
        } else {
            return AuthorizationDecision.unapplicable();
        }
    }
}
